package com.hero.ui.dialog;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.HeroDesigner;
import com.hero.model.DoubleDocument;
import com.hero.objects.Multipower;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.Power;
import com.hero.ui.CompoundPowerPanel;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CompoundPowerDialog extends PowerDialog {

	private static final long serialVersionUID = -53753516294513380L;

	CompoundPowerPanel powerPanel;

	public CompoundPowerDialog(Power object, boolean isNew) {
		super(object, isNew, true, false);
		init();
	}

	@Override
	public int display() {
		setVisible(true);
		if (cancelButtonClicked) {
			return 0;
		} else if (deleteButtonClicked) {
			return -1;
		} else if (okButtonClicked) {
			return 1;
		} else {
			return 0;
		}
	}

	@Override
	protected JPanel getTopPanel() {
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);

		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridwidth = 3;
		gbc.weightx = 0;
		equipmentPanel.add(carriedCB, gbc);
		gbc.gridy++;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridwidth = 1;
		equipmentPanel.add(weightLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		equipmentPanel.add(weightTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 1;
		equipmentPanel.add(new JLabel(HeroDesigner.getInstance().getPrefs()
				.isMetric() ? "kg" : "lbs"), gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = 0;
		equipmentPanel.add(priceLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		if (HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix()) {
			gbc.gridwidth = 2;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.insets = new Insets(2, 0, 5, 2);
			JPanel pricePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
			pricePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
			pricePanel.add(new JLabel(HeroDesigner.getActiveHero().getRules()
					.getEquipmentCostUnits()));
			pricePanel.add(priceTF);
			equipmentPanel.add(pricePanel, gbc);
			gbc.insets = new Insets(2, 5, 5, 2);
		} else {
			gbc.gridwidth = 2;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.insets = new Insets(2, 0, 5, 2);
			JPanel pricePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
			pricePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
			pricePanel.add(priceTF);
			pricePanel.add(new JLabel(HeroDesigner.getActiveHero().getRules()
					.getEquipmentCostUnits()));
			equipmentPanel.add(pricePanel, gbc);
			gbc.insets = new Insets(2, 5, 5, 2);
		}
		equipmentPanel.setBorder(BorderFactory
				.createTitledBorder("Equipment Info."));

		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);

		JPanel panel = new JPanel(new GridBagLayout());
		panel.add(nameLbl, gbc);
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridwidth = 2;
		gbc.weightx = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		panel.add(nameTF, gbc);

		gbc.gridwidth = 1;
		gbc.gridx = 0;
		gbc.gridy = 84;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.anchor = GridBagConstraints.EAST;
		panel.add(quantityLbl, gbc);
		gbc.gridx = 1;
		gbc.gridwidth = 2;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(quantityTF, gbc);

		gbc.gridy = 99;
		gbc.gridx = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		if (object.isEquipment()) {
			panel.add(equipmentPanel, gbc);
		}
		return panel;
	}

	@Override
	protected void init() {
		initWidgets();
		initListeners();
		layoutComponent();
		pack();
		if (HeroDesigner.getInstance().getPrefs().isRememberDialogPosition()) {
			if ((HeroDesigner.getInstance().getPrefs().getDialogX() > 50)
					&& (HeroDesigner.getInstance().getPrefs().getDialogY() > 50)) {
				setSize(new Dimension(HeroDesigner.getInstance().getPrefs()
						.getDialogX(), HeroDesigner.getInstance().getPrefs()
						.getDialogY()));
			} else {
				setSize(getPreferredSize());
			}
			if ((HeroDesigner.getInstance().getPrefs().getDialogScreenX() > 0)
					&& (HeroDesigner.getInstance().getPrefs()
							.getDialogScreenY() > 0)) {
				setLocation(HeroDesigner.getInstance().getPrefs()
						.getDialogScreenX(), HeroDesigner.getInstance()
						.getPrefs().getDialogScreenY());
			} else {
				setLocationRelativeTo(HeroDesigner.getAppFrame());
			}
		} else {
			setSize(getPreferredSize());
			setLocationRelativeTo(HeroDesigner.getAppFrame());
		}
		if (!HeroDesigner.getActiveHero().getRules().multiplierAllowed()) {
			multiplierBtn.setVisible(false);
		} else {
			multiplierBtn.setVisible(true);
		}
		updateValues();
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		multiplierBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MultiplierDialog dialog = new MultiplierDialog();
				dialog.setLocationRelativeTo(CompoundPowerDialog.this);
				dialog.setVisible(true);
				dialog.dispose();
				updateValues();
			}
		});
		powerPanel
				.addUpdateListener(powerPanel.getSelectionList().new UpdateListener() {
					@Override
					public void updatePerformed() {
						updateValues();
					}
				});
		carriedCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				object.setCarried(carriedCB.isSelected());
			}
		});
		priceTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				if (priceTF.getText().trim().length() == 0) {
					object.setPrice(0);
				} else {
					object.setPrice(Double.parseDouble(priceTF.getText()));
				}
			}

			public void insertUpdate(DocumentEvent e) {
				if (priceTF.getText().trim().length() == 0) {
					object.setPrice(0);
				} else {
					object.setPrice(Double.parseDouble(priceTF.getText()));
				}
			}

			public void removeUpdate(DocumentEvent e) {
				if (priceTF.getText().trim().length() == 0) {
					object.setPrice(0);
				} else {
					object.setPrice(Double.parseDouble(priceTF.getText()));
				}
			}
		});
		weightTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				if (weightTF.getText().trim().length() == 0) {
					object.setWeight(0);
				} else {
					object.setWeight(Double.parseDouble(weightTF.getText()));
				}
			}

			public void insertUpdate(DocumentEvent e) {
				if (weightTF.getText().trim().length() == 0) {
					object.setWeight(0);
				} else {
					object.setWeight(Double.parseDouble(weightTF.getText()));
				}
			}

			public void removeUpdate(DocumentEvent e) {
				if (weightTF.getText().trim().length() == 0) {
					object.setWeight(0);
				} else {
					object.setWeight(Double.parseDouble(weightTF.getText()));
				}
			}
		});

		displayActivePointsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				object.setDisplayActiveCost(displayActivePointsCB.isSelected());
			}
		});

		ultraCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				object.setUltra(ultraCB.isSelected());
			}
		});
		nameTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				object.setName(nameTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				object.setName(nameTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				object.setName(nameTF.getText());
			}
		});
		defineBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (object == null) {
					return;
				}
				if (object.getDefinition() == null) {
					return;
				}
				if (object.getDefinition().trim().length() == 0) {
					return;
				}
				PopupMessage popup = PopupMessage.getInstance(HeroDesigner
						.getAppFrame(), defineBtn, object.getDefinition(),
						false);
				popup.setVisible(true);
			}
		});
		cancelBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancelButtonClicked = true;
				deleteButtonClicked = false;
				okButtonClicked = false;
				setVisible(false);
			}
		});
		okBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancelButtonClicked = false;
				deleteButtonClicked = false;
				okButtonClicked = true;
				setVisible(false);
			}
		});
		deleteBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {

				cancelButtonClicked = false;
				deleteButtonClicked = true;
				okButtonClicked = false;
				setVisible(false);
				updateValues();
			}
		});
		/*notesBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				NotesDialog dialog = new NotesDialog(object,
						CompoundPowerDialog.this);
				dialog.setSize(getSize());
				dialog.setLocationRelativeTo(CompoundPowerDialog.this);
				dialog.setVisible(true);
				updateValues();
			}
		});*/
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		multiplierBtn = new JButton("Cost Multiplier");
		powerPanel = new CompoundPowerPanel((CompoundPower) object);
		equipmentPanel = new JPanel(new GridBagLayout());
		carriedCB = new JCheckBox("Carried");
		carriedCB.setSelected(object.isCarried());
		priceLbl = new JLabel("Price: ");
		weightLbl = new JLabel("Weight: ");
		BigDecimal bd = new BigDecimal(object.getPrice());
		bd = bd.setScale(HeroDesigner.getActiveHero().getRules()
				.getEquipmentCostDecimalPlaces(), BigDecimal.ROUND_HALF_UP);
		priceTF = new JTextField(
				new DoubleDocument(99999999999d, -99999999999d), bd.toString(),
				6);
		bd = new BigDecimal(object.getWeight());
		bd = bd.setScale(2, BigDecimal.ROUND_HALF_UP);
		weightTF = new JTextField(new DoubleDocument(99999999999d,
				-99999999999d), bd.toString(), 6);
		activePointsLbl = new JLabel("Active Point:  "
				+ Rounder.roundUp(object.getActiveCost()));
		realCostLbl = new JLabel("Real Cost:  "
				+ Rounder.roundUp(object.getRealCost()));

		displayActivePointsCB = new JCheckBox("Display Cost Totals");
		displayActivePointsCB.setSelected(object.getDisplayActiveCost());

		notesBtn = new JButton("Notes...");
		okBtn = new JButton("OK");
		deleteBtn = new JButton("Delete");
		deleteBtn.setVisible(!isNew);
		cancelBtn = new JButton("Cancel");
		defineBtn = new JButton("Define");
		if ((object.getDefinition() != null)
				&& (object.getDefinition().trim().length() > 0)) {
			defineBtn.setEnabled(true);
		} else {
			defineBtn.setEnabled(false);
		}

		nameLbl = new JLabel("Name:");
		nameTF = new JTextField(object.getName());
		Font font = nameTF.getFont();
		font = new Font(font.getFontName(), Font.ITALIC, font.getSize());
		nameTF.setFont(font);
		if (HeroDesigner.getActiveTemplate().is6E()) {
			ultraCB = new JCheckBox("Fixed Slot");
		} else {
			ultraCB = new JCheckBox("Ultra Slot");
		}
		ultraCB.setSelected(object.isUltra());
	}

	@Override
	protected void layoutComponent() {
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1;
		gbc.weighty = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.insets = new Insets(0, 0, 0, 0);
		gbc.gridy = 0;
		gbc.weighty = 0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(5, 5, 5, 5);
		JPanel panel = new JPanel(new GridBagLayout());
		panel.add(getTopPanel(), gbc);
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 1;
		gbc.gridy++;
		panel.add(activePointsLbl, gbc);
		gbc.gridx = 1;
		gbc.gridwidth = 2;
		gbc.anchor = GridBagConstraints.CENTER;
		JPanel holder = new JPanel(new FlowLayout(FlowLayout.CENTER));
		holder.add(displayActivePointsCB);
		if (isPower && (object.getParentList() != null)
				&& (object.getParentList() instanceof Multipower)) {
			holder.add(ultraCB);
		}
		panel.add(holder, gbc);
		gbc.gridx = 3;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.EAST;
		panel.add(realCostLbl, gbc);
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.weighty = 1;
		gbc.weightx = 1;
		gbc.fill = GridBagConstraints.BOTH;
		panel.add(powerPanel, gbc);
		gbc.gridy++;
		gbc.weighty = 0;
		gbc.weightx = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.NORTH;

		gbc.gridy++;
		gbc.anchor = GridBagConstraints.SOUTH;
		gbc.gridy++;
		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttons.add(notesBtn);
		buttons.add(multiplierBtn);
		buttons.add(okBtn);
		buttons.add(deleteBtn);
		buttons.add(cancelBtn);
		buttons.add(defineBtn);
		panel.add(buttons, gbc);

		setContentPane(panel);
	}

	@Override
	public void layoutExtrasPanel() {
		// do nothing;
	}

	@Override
	public void updateValues() {
		if (!isShowing()) {
			return;
		}
		if ((object.getNotes() != null)
				&& (object.getNotes().trim().length() > 0)) {
			notesBtn.setText("Edit Notes...");
		} else {
			notesBtn.setText("Create Notes...");
		}

		activePointsLbl.setText("Active Points: "
				+ Rounder.roundUp(object.getActiveCost()));
		realCostLbl.setText("Real Cost: "
				+ Rounder.roundUp(object.getRealCost()));
		// powerList.updateTotal();
		validate();
	}

}